using System;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{


		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///	Utility class used to display a wait cursor
		/// while a long operation takes place and
		/// guarantee that it will be removed on exit.
		/// 
		/// Use as follows:
		/// 
		///		using ( new WaitCursor() )
		///		{
		///			// Long running operation goes here
		///		}
		///		
		///</summary>

		#endregion


	public class WaitCursor : IDisposable
	{
		private Cursor cursor;

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// WaitCursor class constructor
		/// </summary>
		public WaitCursor()
		{
			cursor = Cursor.Current;
			Cursor.Current = Cursors.WaitCursor;
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// WaitCursor class dispose method
		/// </summary>
		public void Dispose()
		{
			Cursor.Current = cursor;
		}
	}

}
